﻿//---------------------------------------------------------------------------


#pragma hdrstop

#include "Rejestr.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

bool CzytajUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty)
{
	bool wynik=false;
	TRegistry* Rejestr=new TRegistry; //tworzenie instancji TRegistry
	Rejestr->Access=KEY_READ;  //nadawanie uprawnień do odczytu rejestru
	Rejestr->RootKey=HKEY_CURRENT_USER; //wybór klucza głównego

	if (Rejestr->KeyExists(klucz)) //czy klucz istnieje?
		if (Rejestr->OpenKey(klucz,false)) //otwieranie klucza
		{
			//zapisywanie danych
			if (Rejestr->ValueExists("Left")) okno->Left=Rejestr->ReadInteger("Left");
			if (Rejestr->ValueExists("Top")) okno->Top=Rejestr->ReadInteger("Top");
			if (Rejestr->ValueExists("Width")) okno->Width=Rejestr->ReadInteger("Width");
			if (Rejestr->ValueExists("Height")) okno->Height=Rejestr->ReadInteger("Height");
			Rejestr->CloseKey(); //zamknięcie dostępu do klucza rejestru
			wynik=true;
		}
		else
		{
			if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie może być otwarty.");
		}
	else
	if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie istnieje.");
	delete Rejestr; //usuniecie instancji TRegistry z pamięci
	return wynik;
}

bool ZapiszUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty)
{
	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_WRITE;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	if (!Rejestr->KeyExists(klucz))
		if (!Rejestr->CreateKey(klucz))
		{
			ShowMessage("Klucz \""+klucz+"\" nie może być utworzony.");
			delete Rejestr;
			return false;
		}

	bool wynik=false;

	if (Rejestr->OpenKey(klucz,false))
	{
		Rejestr->WriteInteger("Left",okno->Left);
		Rejestr->WriteInteger("Top",okno->Top);
		Rejestr->WriteInteger("Width",okno->Width);
		Rejestr->WriteInteger("Height",okno->Height);
		Rejestr->CloseKey();
		wynik=true;
	}
	else ShowMessage("Klucz \""+klucz+"\" nie może być otwarty.");

	delete Rejestr;
	return wynik;
}

//---------------------------------------------------------------------------

void ZapiszAutostart(AnsiString nazwa,AnsiString plikEXE)
{
	const AnsiString klucz="\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_SET_VALUE;
	Rejestr->RootKey=HKEY_CURRENT_USER;
	if (Rejestr->OpenKey(klucz,false))
	{
		Rejestr->WriteString(nazwa,plikEXE);
		Rejestr->CloseKey();
	}
	else ShowMessage("Klucz \""+klucz+"\" nie istnieje lub nie może być otwarty.");
	delete Rejestr;
}

void UsunAutostart(AnsiString nazwa)
{
	const AnsiString klucz="\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_SET_VALUE;
	Rejestr->RootKey=HKEY_CURRENT_USER;
	if (Rejestr->OpenKey(klucz,false))
	{
		Rejestr->DeleteValue(nazwa);
		Rejestr->CloseKey();
	}
	else ShowMessage("Klucz \""+klucz+"\" nie istnieje lub nie może być otwarty.");
	delete Rejestr;
}

bool SprawdzAutostart(AnsiString nazwa)
{
	const AnsiString klucz="\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
	bool wynik=false;
	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_QUERY_VALUE;
	Rejestr->RootKey=HKEY_CURRENT_USER;
	if (Rejestr->OpenKey(klucz,false))
	{
		wynik=Rejestr->ValueExists(nazwa);
		Rejestr->CloseKey();
	}
	else ShowMessage("Klucz \""+klucz+"\" nie istnieje lub nie może być otwarty.");
	delete Rejestr;
	return wynik;
}

//---------------------------------------------------------------------------

bool CzytajListePlikow(AnsiString klucz,bool komunikaty,TStrings* ListaPlikow)
{
	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_READ;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	bool Wynik=false;

	if (Rejestr->KeyExists(klucz))
	{
		if (Rejestr->OpenKey(klucz,false))
		{
			TStringList* NazwyWartosci=new TStringList;
			Rejestr->GetValueNames(NazwyWartosci);
			for(int i=0;i<NazwyWartosci->Count;i++)
				ListaPlikow->Add(Rejestr->ReadString(NazwyWartosci->Strings[i]));
			delete NazwyWartosci;
			Rejestr->CloseKey();
			Wynik=true;
		}
		else if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie może być otwarty.");
	}
	else if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie istnieje.");

	delete Rejestr;
	return Wynik;
}

bool ZapiszListePlikow(AnsiString klucz,bool komunikaty,TStrings* ListaPlikow)
{
	bool Wynik=false;

	TRegistry* Rejestr=new TRegistry;
	Rejestr->Access=KEY_WRITE;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	if (!Rejestr->KeyExists(klucz))
		if (!Rejestr->CreateKey(klucz))
		{
			if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie może być utworzony.");
			delete Rejestr;
			return Wynik;
		}

	if (Rejestr->OpenKey(klucz,false))
	{
		//CzyszczenieKlucza(klucz,komunikaty);
		for(int i=0;i<ListaPlikow->Count;i++)
			Rejestr->WriteString("Plik"+IntToStr(i),ListaPlikow->Strings[i]);
		Rejestr->CloseKey();
		Wynik=true;
	}
	else if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie może być otwarty.");

	delete Rejestr;
	return Wynik;
}

